#!/bin/sh

# Script to process an uploaded geop_daily file on the Cion
cd /tmp/uploads

# md5 check of the geop file and the reinit tree
md5sum --check --status geop_daily.md5

if [[ "$?" -eq "1" ]]; then
echo md5sum verification failed on geo_daily.md5 at `time` > /tmp/logs/geop_daily.log
mount -o remount,sync /
sync
mount -o remount,async /
exit 1
fi

md5sum --check --status reinit.tree.md5

if [[ "$?" -eq "1" ]]; then
echo md5sum verification failed on reinit_tree.md5 at `time` >> /tmp/logs/geop_daily.log
mount -o remount,sync /
sync
mount -o remount,async /
exit 1
fi

rm -f /tmp/uploads/geop_daily.md5
rm -f /tmp/uploads/reinit.tree.md5

cd -
mount -o remount,sync /

# Process the uploaded file
mv -f /tmp/uploads/geop_daily /usr/local/instrument/recvNav/config/goa-var/time-pole/iersa/geop_daily
mv -f /tmp/uploads/reinit.tree /var/volatile/RtgxOrbiter/RTGX/.
echo r > /var/volatile/RtgxOrbiter/RTGX/rtgx_controlPipe

# Cleanup
sync
mount -o remount,async /
exit 0
