package L2ProfileHtmlTableParser;
use strict;
use vars qw(@ISA $in_field $in_record $in_table);
use base 'HTML::Parser';

sub start {
    my ($self, $tag, $attr, $attrseq, $orig) = @_;
    if ( $tag eq 'table' ) { $in_table++; $self->{Table} = []; }
    if ( $tag eq 'tr' ) { $in_record++; $self->{Row} = []; }
    if ( $tag eq 'td' ) { $in_field++; $self->{Field} = ''; }
}

sub text {
    my ($self, $text) = @_;
    if ( $in_table && $in_record && $in_field ) { $self->{Field} .= $text; }
}

sub end {
    my ($self, $tag) = @_;
    if ( $tag eq 'table' ) { $in_table--; }
    if ( $tag eq 'tr' ) {
	$in_record--;
	push @{$self->{Table}}, $self->{Row};
    }
    if ( $tag eq 'td' ) {
	$in_field--;
        # Numeric field is first word, possible second word is unit.
	my ($num, $unit) = split ' ', $self->{Field};
        $num = "Null" if $num eq "";
	push @{$self->{Row}}, $num;
    }
}

1;    
  
