package L2ProfileXMLParser;
use strict;
use vars qw(@ISA $in_field $in_record $in_resultset $n_record);

sub new {
    my ($class, $ResultSetTag, $RecordTag) = @_;
    my %s = ();
    $s{ResultSetTag} = $ResultSetTag || "ResultSet";
    $s{RecordTag} = $RecordTag || "Result";
    bless \%s, $class;
}

sub start {
    my ($self, $tag, $attr, $attrseq, $orig) = @_;
    if ( $tag eq $self->{ResultSetTag} ) {
	$in_resultset++;
	$self->{Table} = [];
	$self->{FieldNames} = [];
	$n_record = 0;
    } elsif ( $tag eq $self->{RecordTag} ) {
	$in_record++;
	$self->{Row} = [];
    } else {
	$in_field++;
	$self->{Field} = '';
	if ( $n_record == 0 ) {
	    push @{$self->{FieldNames}}, $tag;
	}
    }
}

sub char {
    my ($self, $text) = @_;
    if ( $in_resultset && $in_record && $in_field ) { $self->{Field} .= $text; }
}

sub end {
    my ($self, $tag) = @_;
    if ( $tag eq $self->{ResultSetTag} ) {
	$in_resultset--;
    } elsif ( $tag eq $self->{RecordTag} ) {
	$in_record--;
	push @{$self->{Table}}, $self->{Row};
    } else {
	$in_field--;
        # Numeric field is first word, possible second word is unit.
	my ($num, $unit) = split ' ', $self->{Field};
        $num = "Null" if $num eq "";
	push @{$self->{Row}}, $num;
    }
}

1;    
  
