#!/usr/local/bin/perl -w 

package XML2Table;

use strict;
use lib "$ENV{'GAIM'}/perllib";
use XML::Parser::Lite;

my ($rFieldNames, $rTable);       # references to arrays to be filled by parse
my ($ResultSetTag, $RecordTag);   # globals for handler routines
my (@Row, $Field);
my ($in_resultset, $in_record, $in_field, $n_record);

sub parse {
    my ($xml_doc, $resultSetTag, $recordTag, $rfieldNames, $rtable) = @_;

    $ResultSetTag = $resultSetTag;
    $RecordTag = $recordTag;
    $rFieldNames = $rfieldNames;
    $rTable = $rtable;

    my $parser = XML::Parser::Lite->new();
    $parser->setHandlers(
			 Start => \&handle_start,
			 Char => \&handle_char,
			 End => \&handle_end
			 );
    $parser->parse($xml_doc);
}

sub handle_start {
    my ($expat, $tag) = @_;
    if ( $tag eq $ResultSetTag ) {
	$in_resultset++;
	@$rTable = ();
	@$rFieldNames = ();
	$n_record = 0;
    } elsif ( $tag eq $RecordTag ) {
	$in_record++;
	@Row = ();
    } else {
	$in_field++;
	$Field = '';
	if ( $n_record == 0 ) {
	    push @$rFieldNames, $tag;
	}
    }
}

sub handle_char {
    my ($expat, $text) = @_;
    if ( $in_resultset && $in_record && $in_field ) { $Field .= $text; }
}

sub handle_end {
    my ($expat, $tag) = @_;
    if ( $tag eq $ResultSetTag ) {
	$in_resultset--;
    } elsif ( $tag eq $RecordTag ) {
	$in_record--;
	$n_record++;
	push @$rTable, [ @Row ];
    } else {
	$in_field--;
        # Numeric field is first word, possible second word is unit.
	my ($num, $unit) = split ' ', $Field;
        $num = "Null" if $num eq "";
	push @Row, $num;
    }
}

1;
