#!/usr/local/bin/perl -w 
# file gpsocc_lookup.pl

if ( @ARGV < 4 ) { print STDERR <<EOS;  exit }
usage: gpsocc_lookup.pl <beg_date_time, YYYY/MM/DD:HH:MM:SS> <end_date_time> <sat, champ|sacc> <datatype, gps|NCEP|ECMWF> [<lat_range, low:high>] [<lon_range, low:high>]
EOS

use strict;
use lib "$ENV{'GAIM'}/perllib";
use SOAP::Lite;
use DateTime;

use constant GENESIS_SQL_PORT => 'http://gilaan.usc.edu:8888/axis/ServerLogicxs.jws';
use constant GENESIS_SQL_URN => 'urn:Genesis_SQL';
my %DATATYPES = ( gps => 'gpsProfile',
	          ncep => 'NCEPFNLProfile',
	          ecmwf => 'ECMWFProfile'  );

my $beg = shift @ARGV;
# convert yyyy/mm/dd,hh:mm:ss to yyyymmdd_hhmm
my ($year, $mon, $day, $hour, $min, $sec, $frac) =
        (new DateTime)->fromCalStr($beg)->toCal();
my $date_time_format = "%4.4d%2.2d%2.2d_%2.2d%2.2d";
my $beg_date_time = sprintf $date_time_format, $year, $mon, $day, $hour, $min;

my $end = shift @ARGV;
($year, $mon, $day, $hour, $min, $sec, $frac) =
        (new DateTime)->fromCalStr($end)->toCal();
my $end_date_time = sprintf $date_time_format, $year, $mon, $day, $hour, $min;

my $sat = shift @ARGV;
my $db = "jpl$sat";
my $type = lc shift @ARGV;
die  "gpsocc_lookup.pl: Datatype must be one of: gps, ncep, or ecmwf."
    unless $type =~ m/gps|ncep|ecmwf/;
my $datatype = $DATATYPES{$type};

my $lat_range = shift @ARGV || "";
my $lon_range = shift @ARGV || "";

# Construct SQL query to fetch L2 profile retrieval along with some metadata.
my $sql = <<EOS;
select * from l2data where datasetid in (
select datasetid from l2header where
datasetid >= '$beg_date_time%' and datasetid < '$end_date_time%' )
and datatype = '$datatype'
EOS

if ( defined $lat_range && $lat_range ne "" ) {
    my ($lat1, $lat2) = split ':', $lat_range;
    $sql .= " and lat >= $lat1 and lat < $lat2";
}
if ( defined $lon_range && $lon_range ne "" ) {
    my ($lon1, $lon2) = split ':', $lon_range;
    $sql .= " and lon >= $lon1 and lon < $lon2";
}

print STDERR "Query:\n$sql\n";
my $result = SOAP::Lite
  ->uri(GENESIS_SQL_URN)
  ->proxy(GENESIS_SQL_PORT)
  ->executeQuery($sql, $db)
  ->result;
print $result;

