#!/usr/local/bin/perl -w 

use strict;
use lib "/gaim/perllib";
use SOAP::Transport::HTTP;
use SOAP::Lite;
use DateTime;

SOAP::Transport::HTTP::CGI
  ->dispatch_to('SearchOcc')
  ->handle;

package SearchOcc;

sub executeQuery {
  my($self, $beg, $end, $sat, $type, $lat_range, $lon_range) = @_;


use constant GENESIS_SQL_PORT => 'http://gilaan.usc.edu:8888/axis/ServerLogicxs.jws';
use constant GENESIS_SQL_URN => 'urn:Genesis_SQL';
my %DATATYPES = ( gps => 'gpsProfile',
	          ncep => 'NCEPFNLProfile',
	          ecmwf => 'ECMWFProfile'  );

# convert yyyy/mm/dd,hh:mm:ss to yyyymmdd_hhmm
my ($year, $mon, $day, $hour, $min, $sec, $frac) =
        (new DateTime)->fromCalStr($beg)->toCal();
my $date_time_format = "%4.4d%2.2d%2.2d_%2.2d%2.2d";
my $beg_date_time = sprintf $date_time_format, $year, $mon, $day, $hour, $min;

($year, $mon, $day, $hour, $min, $sec, $frac) =
        (new DateTime)->fromCalStr($end)->toCal();
my $end_date_time = sprintf $date_time_format, $year, $mon, $day, $hour, $min;

my $db = "jpl$sat";
$type = lc $type;
die  "search_occ_server.pl: Datatype must be one of: gps, ncep, or ecmwf."
    unless $type =~ m/gps|ncep|ecmwf/;
my $datatype = $DATATYPES{$type};

# Construct SQL query to fetch L2 profile retrieval along with some metadata.
my $sql = <<EOS;
select * from l2data where datasetid in (
select datasetid from l2header where
datasetid >= '$beg_date_time%' and datasetid < '$end_date_time%' )
and datatype = '$datatype'
EOS

if ( defined $lat_range && $lat_range ne "" ) {
    my ($lat1, $lat2) = split ':', $lat_range;
    $sql .= " and lat >= $lat1 and lat < $lat2";
}
if ( defined $lon_range && $lon_range ne "" ) {
    my ($lon1, $lon2) = split ':', $lon_range;
    $sql .= " and lon >= $lon1 and lon < $lon2";
}

print STDERR "Query:\n$sql\n";

return SOAP::Lite
  ->uri('urn:Genesis_SQL')
  ->proxy('https://genesis:password@gilaan.usc.edu:8888/axis/ServerLogicxs.jws')
  ->executeQuery($sql, $db)
  ->result;
}

